﻿
// Generate at 2023-08-29 11:16:08
var ServiSignErrorCode = 61001;

String.prototype.replaceAll = function(search, replacement) {
	var target = this
	return target.split(search).join(replacement)
}

if (!String.prototype.startsWith) {
	String.prototype.startsWith = function(searchString, position) {
		position = position || 0
		return this.indexOf(searchString, position) === position
	}
	String.prototype.endsWith = function(pattern) {
		var d = this.length - pattern.length
		return d >= 0 && this.lastIndexOf(pattern) === d
	}
}

function getKGICGCAPIATLSVIAdapterObj(cb, timeout) {

	//如有任何參數問題，請參考第 10, 11點
	//https://redmine.changingtec.com/redmine/projects/servisign/wiki/%E5%95%8F%E9%A1%8C%E8%88%87%E8%A7%A3%E7%AD%94

	//底層元件 Adapter 名稱
	var LibName = "KGICGCAPIATLSVIAdapter"
	//底層元件 Adapter 所在位置
	var LibDir = "KGI"
	//Path ID
	var PathID = ""

	//最低 ServiSign 版本 0.0.0.0 = 預設不開啟
	var minServiSignVersion = "0.0.0.0"
	//最低元件版本 0.0.0.0 = 預設不開啟
	var minLibVersion = "0.0.0.0"

	//最低不需更新安裝包版本
	var MinimalInstallerVersion = "1.0.23.0829"
	var MinimalInstallerVersion_Mac = ""
	var MinimalInstallerVersion_Linux = ""
	//JS 模板版本號 ServiSign 主程式會做相容性版本確認
	var JSVersion = "1.0.21.0224"

	//Tab 以分頁做為轉換模式，行為模式與 ActiveX 元件相同
	var ServiSignTabMode_Tab = 			0x0
	//Browser 模式則是以瀏覽器為單位，整個瀏覽器關掉才會釋放元件
	var ServiSignTabMode_Browser = 		0x1

	var ServiSignTabMode = ServiSignTabMode_Tab

	//預設不使用 cookie 儲存 Try port 的結果
	var useCookieTryPort = false

	//路徑保護
	//DataObj.pfxpath_servisignflag = true
	//DataObj.pfxpath = pfxpath.replace(/\\/g, "*")

	//開啟元件 UI 置頂功能
	//DataObj.topuidetect = true
	//開啟全系統 UI 置頂功能
	//DataObj.topuialldetect = true
	//開啟非同步功能
	//DataObj.asynchronously = true

	//資料斜線保護功能
	//DataObj.XXXXX_ServiSignSlashFlag = true
	//DataObj.XXXXX = inputXXXXXX.replaceAll("\\", "==ServiSignSlash==")
	//資料 Base64 保護功能
	//DataObj.XXXXX_ServiSignBase64Flag = true
	//DataObj.XXXXX = Base64Encode(XXXXX)
	//使用主線程呼叫 API
	//DataObj.ServiSignMainThread = true
	//變數保護功能
	//目前已經針對 pin, pw 跟 pass 等關鍵字顯示時自動遮蔽內容
	//如果想要額外遮蔽可在此調整:D
	//DataObj.XXXXX_ServiSignHide = true
	//回傳時可以隱藏 log
	//DataObj.hide_result = true


	function ServiSignConnectError() {
		//ServiSign_RTN_CONNECTION_ERROR
		ServiSignErrorCode = 61006
	}
	function ServiSignLoadComponentError() {
		//Handing load component error
	}
	function ServiSignDisconnectError() {
		//Handing disconnect error
		ServiSignErrorCode = 61015
	}

	var VersionCompare_Error = 			0x00
	var VersionCompare_Bigger =			0x01
	var VersionCompare_Smaller = 		0x02
	var VersionCompare_Same = 			0x03

	function ServiSignLog(LogMessage) {
		console.log("[ServiSign Log] " + LogMessage)
	}
	function Sleep(milliseconds) {
		var start = new Date().getTime()
		for (var i = 0; i < 1e7; i++) {
			if ((new Date().getTime() - start) > milliseconds){
				break
			}
		}
	}
	function Base64Encode(input) {
		return encodeURIComponent(window.btoa(unescape(encodeURIComponent(input))))
	}
	function Base64Decode(input) {
		if(input == undefined) return ""
		return decodeURIComponent(escape(window.atob(input)))
	}
	function FixArray(inputArray) {
		ServiSignLog("FixArray: " + inputArray)
		var array = inputArray.split(";")

		// while(array.indexOf("") != -1){
		// 	var EmptyIndex = array.indexOf("")
		// 	array.splice(EmptyIndex, 1)
		// }

		array.toArray = function(){
			return this
		}
		array.splice(-1, 1);
		return array
	}
	function isServiSignErrorCode(input) {
		var ErrorCode = parseInt(input) || 0
		return (61000 < ErrorCode && ErrorCode < 61999)
	}
	function getCookie(CookieName) {
		var TargetName = CookieName + "="
		var CookieArray = document.cookie.split(';')
		for (var i = 0; i < CookieArray.length; i++) {
			var CookieElement = CookieArray[i]
			while (CookieElement.charAt(0) == ' ') {
				CookieElement = CookieElement.substring(1)
			}
			if (CookieElement.indexOf(TargetName) == 0) {
				return CookieElement.substring(TargetName.length, CookieElement.length)
			}
		}
		return ""
	}
	function VersionCompare(VersionA, VersionB) {
		var iVersionA = parseInt(VersionA.replaceAll(",","").replaceAll(".","").replaceAll(" ","")) || 0
		var iVersionB = parseInt(VersionB.replaceAll(",","").replaceAll(".","").replaceAll(" ","")) || 0

		if(iVersionA == 0 || iVersionB == 0) return VersionCompare_Error
		if(iVersionA > iVersionB) return VersionCompare_Bigger
		if(iVersionA < iVersionB) return VersionCompare_Smaller
		return VersionCompare_Same
	}
	function BrowserDetection() {
		var sBrowser, sUsrAg = navigator.userAgent

		if(sUsrAg.indexOf("Edg") > -1){
			sBrowser = "Edge"
		} else if(sUsrAg.indexOf("Chrome") > -1) {
			sBrowser = "Chrome"
		} else if (sUsrAg.indexOf("Safari") > -1) {
			sBrowser = "Safari"
		} else if (sUsrAg.indexOf("Opera") > -1) {
			sBrowser = "Opera"
		} else if (sUsrAg.indexOf("Firefox") > -1) {
			sBrowser = "Firefox"
		} else if (sUsrAg.indexOf("MSIE") > -1 || sUsrAg.indexOf("Trident/7.0") > -1) {
			sBrowser = "Internet Explorer"
		} else {
			sBrowser = "unknown"
		}

		return sBrowser
	}
	function detectOS() {
		// https://stackoverflow.com/questions/38241480/detect-macos-ios-windows-android-and-linux-os-with-js
		var userAgent = window.navigator.userAgent,
			platform = window.navigator.platform,
			macosPlatforms = ['Macintosh', 'MacIntel', 'MacPPC', 'Mac68K'],
			windowsPlatforms = ['Win32', 'Win64', 'Windows', 'WinCE'],
			os = null;

		if (macosPlatforms.indexOf(platform) !== -1) {
		  	os = 'Mac'
		}
		else if (windowsPlatforms.indexOf(platform) !== -1) {
		  	os = 'Windows'
		}
		else if (!os && /Linux/.test(platform)) {
		  	os = 'Linux'
		}

		return os
	}
	function verifyURL(input){

		if(input.indexOf("alert(") >= 0){
			return ""
		}

		if(input.indexOf('https://localhost:') != 0 && input.indexOf('https://127.0.0.1:') != 0){
			return ""
		}

		return encodeURI(input)
	}

	// https://github.com/ricmoo/aes-js
// 	var key_exchange = new CG_key_exchange()
	var iv = [169, 195, 229, 121, 17, 13, 137, 122, 194, 158, 71, 31, 245, 165, 190, 254]
	var share_secret = undefined
	var aesCbc = undefined

	function encrypt(msg){

		if(share_secret == undefined){
			return Base64Encode(msg)
		}

		aesCbc = new aesjs.ModeOfOperation.cbc(share_secret, iv)

		while(msg.length % 16 != 0){
			msg += '\0'
		}
		var textBytes = aesjs.utils.utf8.toBytes(msg)
		var encryptedBytes = aesCbc.encrypt(textBytes)

		var encrypted_hex = aesjs.utils.hex.fromBytes(encryptedBytes)

		return Base64Encode(encrypted_hex)
	}

	function decrypt(msg){

		var encryptedBytes = aesjs.utils.hex.toBytes(msg)
		var aesCbc = new aesjs.ModeOfOperation.cbc(share_secret, iv)
		var decryptedBytes = aesCbc.decrypt(encryptedBytes)
		var decryptedText = aesjs.utils.utf8.fromBytes(decryptedBytes)

		decryptedText = decryptedText.substring(decryptedText.search("{"), decryptedText.search("}") + 1);
		return decryptedText
	}

	function getServiSignObj() {
		var portList = [56312, 56322, 56342]
		var InstallerName = "KGICGCAPIATL2ADPTSetup"

		var Url_Part1_DNS = 'https://localhost:'
		var Url_Part1_IP = 'https://127.0.0.1:'
		var SessionID =""
		var ServiSignUrl = ""

		var realServiSignVersion = ""
		var realLibVersion = ""
		var realInstallerVersion = ""
		var CurrenOSMinimalInstallerVersion = null

		var needUpdate = false
		var Browser = ""
		var OS = null

		var ServiSignObjResultObj = undefined

		function defaultCallback(){return ;}
		var CallbackFunction

		var isLocked = false
		var isInitialized = false

		var ServiSignObj =
		{
			xhr_timeout: 0,
			clearServiSignCallback : function(){
				ServiSignLog("CallbackFunction empty")
				CallbackFunction = undefined
			},
			setServiSignCallback : function(InputFunction){
				if(typeof InputFunction != "function"){
					CallbackFunction = defaultCallback
				}
				else{
					CallbackFunction = function (resultObj, url) {
						var result
						try {
							result = Base64Decode(resultObj.result)
						}
						catch(err) {
							result = ""
						}

						InputFunction(result)
					}
				}
			},
			KeepAlive : function (DataObj){
				var temp = ""
				DataObj.KeepAlive = true
				DataObj.topuidetect = true
				DataObj.ServiSignMainThread = true
				if (CallbackFunction) {
					var originalCallback = CallbackFunction
					CallbackFunction = function (result, url) {
						if (result == "heartbeat") {
							ServiSignObj.Send(DataObj)
						} else {
							originalCallback(result, url);
						}
					}
					ServiSignObj.Send(DataObj)
				} else {
					do{
						temp = ServiSignObj.Send(DataObj)
					}while(temp == "heartbeat")
				}
				return temp
			},
			sendData : function(url, DataObj){
				var XMLHttpRequestAsynchronously = CallbackFunction ? true: false

				if (XMLHttpRequestAsynchronously && isLocked) {
					setTimeout(this.sendData, 100, url, DataObj)
					return
				}

				var xhr = new XMLHttpRequest()

				try{
					if(verifyURL(url) == ""){
						return undefined
					}
					xhr.open('MagicMethodA|POST|MagicMethodB'.split('|')[1], verifyURL(url), XMLHttpRequestAsynchronously)
				}
				catch(err) {
					return undefined
				}
				xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded")

				if(XMLHttpRequestAsynchronously){
					isLocked = true
					xhr.mycallback = CallbackFunction;
					ServiSignObj.clearServiSignCallback()
					xhr.timeout = this.xhr_timeout
					this.xhr_timeout = 0
				}

				var onLoadHandler = function(event){
					try {
						var response_text = this.responseText
						if(!response_text.startsWith('{') || !response_text.endsWith('}')){
							response_text = decrypt(response_text)
						}
						ServiSignObjResultObj = JSON.parse(response_text)
					}
					catch(err) {
						console.log(err)
						ServiSignObjResultObj = undefined
					}

					if(this.mycallback){
						this.mycallback(ServiSignObjResultObj, ServiSignUrl)
					}
				}
				xhr.onload = onLoadHandler

				var onFailedHandler = function (event) {
					isLocked = false
					ServiSignConnectError()
					ServiSignObjResultObj = undefined
					if(this.mycallback){
						this.mycallback(undefined, ServiSignUrl)
					}
				}

				xhr.ontimeout = onFailedHandler
				xhr.onerror = onFailedHandler
				DataObj.comname = LibName
				DataObj.libdir = LibDir
				if(ServiSignTabMode == ServiSignTabMode_Tab){
					DataObj.sessionid = SessionID
				}
				else if(ServiSignTabMode == ServiSignTabMode_Browser){
					DataObj.sessionid = Browser
				}
				DataObj.ServiSignTabMode = ServiSignTabMode
				DataObj.ServiSignBrowser = Browser
				DataObj.JSVersion = JSVersion
				DataObj.minlibversion = minLibVersion
				DataObj.minserverversion = minServiSignVersion
				DataObj.InstallerName = InstallerName
				DataObj.PathID = PathID
				DataObj.ServiSignJSGenTime = "2023-08-29 11:16:08"

				// For new version form 20190416
				DataObj.AdapterJsonKeyCheck = true

				var readyDataObj = "Parameter=" + encrypt(JSON.stringify(DataObj))

				try {
					xhr.send(readyDataObj)
				}
				catch(err) {
					var header = xhr.getResponseHeader("via")
					if (header) {
						ServiSignErrorCode = 61014
					}
					else{
						ServiSignDisconnectError()
					}
					return undefined
				}
				return ServiSignObjResultObj
			},
			GetUrlList: function () {
				let urlList = [];
				for (var i = 0; i < portList.length; i++) {
					urlList.push(Url_Part1_DNS + (OS === "Mac" ? portList[i] - 2000 : portList[i]));
				}

				for (var i = 0; i < portList.length; i++) {
					urlList.push(Url_Part1_IP + (OS === "Mac" ? portList[i] - 2000 : portList[i]));
				}

				return urlList;
			},
			TryPort : function() {
				var resultObj
				var DataObj = new Object()
				var ErrorCode = 0

				OS = detectOS()
				Browser = BrowserDetection()

				ServiSignLog(OS)
				ServiSignLog(Browser)

				DataObj.functionname = "ServiSignEcho"
				// if(useCookieTryPort){
				// 	ServiSignUrl = getCookie("ServiSignUrl")
				// }
				// else{
				// 	ServiSignUrl = ""
				// }
				ServiSignUrl = ""

// 				key_exchange.init()
// 				DataObj.public_key_hex = key_exchange.public_key_hex

				var urlList = this.GetUrlList()
				if (typeof cb == "function") {
					var index = 0
					if (typeof timeout != "number") {
						timeout = 500
					}

					var trycb = function (resultObj, url) {
						if (isInitialized) return

						if (resultObj) {
							var result = Base64Decode(resultObj.result)
							if (result == "" || result == "0") {
								isInitialized = true
								realServiSignVersion = Base64Decode(resultObj.ServerVersion)
								realLibVersion = Base64Decode(resultObj.LibVersion)
								realInstallerVersion = Base64Decode(resultObj.InstallerVersion)

								if(SessionID == "") {
									SessionID = Base64Decode(resultObj.SessionID)
								}

								if(OS == "Windows"){
									CurrenOSMinimalInstallerVersion = MinimalInstallerVersion
								}
								else if(OS == "Mac"){
									CurrenOSMinimalInstallerVersion = MinimalInstallerVersion_Mac
								}
								else if(OS == "Linux"){
									CurrenOSMinimalInstallerVersion = MinimalInstallerVersion_Linux
								}

								needUpdate = (VersionCompare(CurrenOSMinimalInstallerVersion, realInstallerVersion) == VersionCompare_Bigger || VersionCompare(CurrenOSMinimalInstallerVersion, realInstallerVersion) == VersionCompare_Error)

								var public_key_hex = Base64Decode(resultObj.public_key_hex)

								console.log('recv public_key_hex ' + public_key_hex)

								try {
// 									key_exchange.compute_share_secret(public_key_hex)
// 									share_secret = key_exchange.share_secret
								}
								catch(err) {}

								ServiSignErrorCode = 0
								setTimeout(cb, 0, true)
								return
							}

							ServiSignLog("Error code: " + result)
							ServiSignErrorCode = parseInt(result)
							if(ServiSignErrorCode == 61014){
								// 使用了 Proxy
								// if(useCookieTryPort){
								// 	document.cookie = "ServiSignUrl=fail"
								// }
								ServiSignLog("Using proxy")
							}
							if(ServiSignErrorCode != 61006){
								return
							}
						}

						if (index < urlList.length) {
							CallbackFunction = trycb
							ServiSignLog("Echo URL: " + urlList[index])
							this.xhr_timeout = timeout
							setTimeout(ServiSignObj.sendData, 0, urlList[index++], DataObj)
						} else {
							ServiSignConnectError()
							setTimeout(cb, 0, false)
						}
					}

					CallbackFunction = trycb
					ServiSignLog("Echo URL: " + urlList[index])
					ServiSignUrl = url
					this.xhr_timeout = timeout
					this.sendData(urlList[index++], DataObj)
					return
				}

				if(ServiSignUrl == "" || ServiSignUrl == "fail") {
					for (var i = 0; i < urlList.length; i++) {
						var url = urlList[i]

						ServiSignLog("Echo URL: " + url)

						resultObj = this.sendData(url, DataObj)
						if(resultObj != undefined){

							ErrorCode = Base64Decode(resultObj.result)

							if(ErrorCode != "" && ErrorCode != "0") {
								ServiSignLog("Error code: " + ErrorCode)
								ServiSignErrorCode = parseInt(ErrorCode)
								if(ServiSignErrorCode == 61006){
									continue
								}
								return false
							}
							ServiSignUrl = url
							break
						}
						if(ServiSignErrorCode == 61014){
							// 使用了 Proxy
							// if(useCookieTryPort){
							// 	document.cookie = "ServiSignUrl=fail"
							// }
							ServiSignLog("Using proxy")
							return false
						}
					}
				}
				else{
					ServiSignLog("Echo URL: " + ServiSignUrl)
					resultObj = this.sendData(ServiSignUrl, DataObj)
				}

				if(resultObj == undefined){
					// if(useCookieTryPort){
					// 	document.cookie = "ServiSignUrl=fail"
					// }
					ServiSignConnectError()
					return false
				}

				ServiSignErrorCode = parseInt(ErrorCode) || 0
				if(ServiSignErrorCode == 0){
					// if(useCookieTryPort){
					// 	document.cookie = "ServiSignUrl=" + ServiSignUrl
					// }
				}
				else{
					// if(useCookieTryPort){
					// 	document.cookie = "ServiSignUrl=fail"
					// }
					return false
				}

				realServiSignVersion = Base64Decode(resultObj.ServerVersion)
				realLibVersion = Base64Decode(resultObj.LibVersion)
				realInstallerVersion = Base64Decode(resultObj.InstallerVersion)

				if(SessionID == "") {
					SessionID = Base64Decode(resultObj.SessionID)
				}

				if(OS == "Windows"){
					CurrenOSMinimalInstallerVersion = MinimalInstallerVersion
				}
				else if(OS == "Mac"){
					CurrenOSMinimalInstallerVersion = MinimalInstallerVersion_Mac
				}
				else if(OS == "Linux"){
					CurrenOSMinimalInstallerVersion = MinimalInstallerVersion_Linux
				}

				needUpdate = (VersionCompare(CurrenOSMinimalInstallerVersion, realInstallerVersion) == VersionCompare_Bigger || VersionCompare(CurrenOSMinimalInstallerVersion, realInstallerVersion) == VersionCompare_Error)

				var public_key_hex = Base64Decode(resultObj.public_key_hex)

				console.log('recv public_key_hex ' + public_key_hex)

				try {
// 					key_exchange.compute_share_secret(public_key_hex)
// 					share_secret = key_exchange.share_secret
				}
				catch(err) {}


				ServiSignErrorCode = 0
				return true
			},
			Send : function(DataObj) {
				DataObj.comname = LibName
				var resultObj = this.sendData(ServiSignUrl, DataObj)
				try {
					return Base64Decode(resultObj.result)
				}
				catch(err) {
					return ""
				}
			},
			getCGServiSignVersion : function() {
				return realServiSignVersion
			},
			getLibVersion : function() {
				return realLibVersion
			},
			getInstallerVersion : function() {
				return realInstallerVersion
			},
			getMinimalInstallerVersion : function() {
				return CurrenOSMinimalInstallerVersion
			},
			ServiSigninit : function() {
				var XMLHttpRequestSupported = typeof new XMLHttpRequest().responseType === 'string'

				if(!XMLHttpRequestSupported) {
					alert("This Browser does NOT support XMLHttpRequest")
					return false
				}
				return this.TryPort()
			},
			ServiSignRelease : function() {
				if(ServiSignErrorCode != 0){
					return
				}

				var empty_func = function() { return undefined; };
				this.setServiSignCallback(empty_func)

				var DataObj = new Object()
				DataObj.functionname = "ServiSignRelease"
				DataObj.minlibversion = minLibVersion
				this.Send(DataObj)

				realServiSignVersion = ""
				realLibVersion = ""
				realInstallerVersion = ""
				CurrenOSMinimalInstallerVersion = null

				SessionID = ""
				needUpdate = false
				ServiSignErrorCode = 0
			},
			ServiSignForceRelease : function() {
				var DataObj = new Object()
				DataObj.functionname = "ServiSignForceRelease"
				DataObj.minlibversion = minLibVersion
				this.Send(DataObj)

				realServiSignVersion = ""
				realLibVersion = ""
				realInstallerVersion = ""
				CurrenOSMinimalInstallerVersion = null

				SessionID = ""
				needUpdate = false
				ServiSignErrorCode = 0
			},
			needUpdateInstaller : function() {
				return needUpdate
			},
			setServiSignValue : function(channel, domain_list, timeout, value){
				var DataObj = new Object()
				DataObj.functionname = "setServiSignValue"
				DataObj.channel = channel
				DataObj.domain_list = domain_list
				DataObj.timeout = timeout
				DataObj.value = value
				DataObj.value_ServiSignHide = true
				return this.Send(DataObj)
			},
			getServiSignValue : function(channel){
				var DataObj = new Object()
				DataObj.functionname = "getServiSignValue"
				DataObj.channel = channel
				DataObj.hide_result = true
				return this.Send(DataObj)
			}
		}
		return ServiSignObj
	}
	var ServiSignObj = getServiSignObj()
	var ServiSignInterface =
	{
		GetServiSignVersion : function() {
			return ServiSignObj.getCGServiSignVersion()
		},
		GetLibVersion : function() {
			return ServiSignObj.getLibVersion()
		},
		GetInstallerVersion : function() {
			return ServiSignObj.getInstallerVersion()
		},
		GetMinimalInstallerVersion : function() {
			return ServiSignObj.getMinimalInstallerVersion()
		},
		SetServiSignCallback : function(InputFunction) {
			ServiSignObj.setServiSignCallback(InputFunction)
		},
		SetConnectionTimeout: function (milliseconds) {
			ServiSignObj.xhr_timeout = milliseconds;
		},
		NeedUpdateInstaller : function() {
			return ServiSignObj.needUpdateInstaller()
		},
		ServiSignForceRelease : function() {
			return ServiSignObj.ServiSignForceRelease()
		},
		SetServiSignValue : function(channel, domain_list, timeout, value){
			return ServiSignObj.setServiSignValue(channel, domain_list, timeout, value)
		},
		GetServiSignValue : function(channel){
			return ServiSignObj.getServiSignValue(channel)
		},
		ServiSignCheckUpdate : function(){
			//if (ServiSignErrorCode != 0) { return }

			var DataObj = new Object()
			DataObj.functionname = "ServiSignCheckUpdate"
			DataObj.minlibversion = minLibVersion

			return ServiSignObj.Send(DataObj)
		},

		ServiSignProperty_propput_HashAlgorithm : function(PropertyParameter){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propput_HashAlgorithm"
			DataObj.PropertyParameter_ServiSignBase64Flag = true
			DataObj.PropertyParameter = Base64Encode(PropertyParameter)
			DataObj.ServiSignFunctionIndex = 0

			return parseInt(ServiSignObj.Send(DataObj))
		},
		ServiSignProperty_propget_HashAlgorithm : function(){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propget_HashAlgorithm"
			DataObj.ServiSignFunctionIndex = 1

			return ServiSignObj.Send(DataObj)
		},
		ServiSignProperty_propput_providerType : function(PropertyParameter){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propput_providerType"
			DataObj.PropertyParameter_ServiSignBase64Flag = true
			DataObj.PropertyParameter = Base64Encode(PropertyParameter)
			DataObj.ServiSignFunctionIndex = 2

			return parseInt(ServiSignObj.Send(DataObj))
		},
		ServiSignProperty_propget_providerType : function(){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propget_providerType"
			DataObj.ServiSignFunctionIndex = 3

			return parseInt(ServiSignObj.Send(DataObj))
		},
		ServiSignProperty_propput_providerName : function(PropertyParameter){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propput_providerName"
			DataObj.PropertyParameter_ServiSignBase64Flag = true
			DataObj.PropertyParameter = Base64Encode(PropertyParameter)
			DataObj.ServiSignFunctionIndex = 4

			return parseInt(ServiSignObj.Send(DataObj))
		},
		ServiSignProperty_propget_providerName : function(){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propget_providerName"
			DataObj.ServiSignFunctionIndex = 5

			return ServiSignObj.Send(DataObj)
		},
		ServiSignProperty_propput_KeySpec : function(PropertyParameter){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propput_KeySpec"
			DataObj.PropertyParameter_ServiSignBase64Flag = true
			DataObj.PropertyParameter = Base64Encode(PropertyParameter)
			DataObj.ServiSignFunctionIndex = 6

			return parseInt(ServiSignObj.Send(DataObj))
		},
		ServiSignProperty_propget_KeySpec : function(){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propget_KeySpec"
			DataObj.ServiSignFunctionIndex = 7

			return parseInt(ServiSignObj.Send(DataObj))
		},
		ServiSignProperty_propput_GenKeyFlags : function(PropertyParameter){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propput_GenKeyFlags"
			DataObj.PropertyParameter_ServiSignBase64Flag = true
			DataObj.PropertyParameter = Base64Encode(PropertyParameter)
			DataObj.ServiSignFunctionIndex = 8

			return parseInt(ServiSignObj.Send(DataObj))
		},
		ServiSignProperty_propget_GenKeyFlags : function(){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propget_GenKeyFlags"
			DataObj.ServiSignFunctionIndex = 9

			return parseInt(ServiSignObj.Send(DataObj))
		},
		ServiSignProperty_propput_DeleteRequestCert : function(PropertyParameter){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propput_DeleteRequestCert"
			DataObj.PropertyParameter_ServiSignBase64Flag = true
			DataObj.PropertyParameter = Base64Encode(PropertyParameter)
			DataObj.ServiSignFunctionIndex = 10

			return parseInt(ServiSignObj.Send(DataObj))
		},
		ServiSignProperty_propget_DeleteRequestCert : function(){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propget_DeleteRequestCert"
			DataObj.ServiSignFunctionIndex = 11

			return parseInt(ServiSignObj.Send(DataObj))
		},
		ServiSignProperty_propput_WriteCertToCSP : function(PropertyParameter){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propput_WriteCertToCSP"
			DataObj.PropertyParameter_ServiSignBase64Flag = true
			DataObj.PropertyParameter = Base64Encode(PropertyParameter)
			DataObj.ServiSignFunctionIndex = 12

			return parseInt(ServiSignObj.Send(DataObj))
		},
		ServiSignProperty_propget_WriteCertToCSP : function(){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propget_WriteCertToCSP"
			DataObj.ServiSignFunctionIndex = 13

			return parseInt(ServiSignObj.Send(DataObj))
		},
		ServiSignProperty_propput_friendlyName : function(PropertyParameter){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propput_friendlyName"
			DataObj.PropertyParameter_ServiSignBase64Flag = true
			DataObj.PropertyParameter = Base64Encode(PropertyParameter)
			DataObj.ServiSignFunctionIndex = 14

			return parseInt(ServiSignObj.Send(DataObj))
		},
		ServiSignProperty_propget_friendlyName : function(){
			var DataObj = new Object()
			DataObj.functionname = "ServiSignProperty_propget_friendlyName"
			DataObj.ServiSignFunctionIndex = 15

			return ServiSignObj.Send(DataObj)
		},
		SetCodePage : function(codepage){
			var DataObj = new Object()
			DataObj.functionname = "SetCodePage"
			DataObj.codepage_ServiSignBase64Flag = true
			DataObj.codepage = Base64Encode(codepage)
			DataObj.ServiSignFunctionIndex = 16

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPIVerify : function(strSignature, bData, strSubject, Flags, iKeyUsage, nTime){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIVerify"
			DataObj.strSignature_ServiSignBase64Flag = true
			DataObj.strSignature = Base64Encode(strSignature)
			DataObj.bData_ServiSignBase64Flag = true
			DataObj.bData = Base64Encode(bData)
			DataObj.strSubject_ServiSignBase64Flag = true
			DataObj.strSubject = Base64Encode(strSubject)
			DataObj.Flags_ServiSignBase64Flag = true
			DataObj.Flags = Base64Encode(Flags)
			DataObj.iKeyUsage_ServiSignBase64Flag = true
			DataObj.iKeyUsage = Base64Encode(iKeyUsage)
			DataObj.nTime_ServiSignBase64Flag = true
			DataObj.nTime = Base64Encode(nTime)
			DataObj.ServiSignFunctionIndex = 17

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPIEncrypt : function(strSubject, istore, iSelCertFlags, bData, Flags, iKeyUsage){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIEncrypt"
			DataObj.strSubject_ServiSignBase64Flag = true
			DataObj.strSubject = Base64Encode(strSubject)
			DataObj.istore_ServiSignBase64Flag = true
			DataObj.istore = Base64Encode(istore)
			DataObj.iSelCertFlags_ServiSignBase64Flag = true
			DataObj.iSelCertFlags = Base64Encode(iSelCertFlags)
			DataObj.bData_ServiSignBase64Flag = true
			DataObj.bData = Base64Encode(bData)
			DataObj.Flags_ServiSignBase64Flag = true
			DataObj.Flags = Base64Encode(Flags)
			DataObj.iKeyUsage_ServiSignBase64Flag = true
			DataObj.iKeyUsage = Base64Encode(iKeyUsage)
			DataObj.ServiSignFunctionIndex = 18

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIDecrypt : function(strCipher, Flags, iKeyUsage){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIDecrypt"
			DataObj.strCipher_ServiSignBase64Flag = true
			DataObj.strCipher = Base64Encode(strCipher)
			DataObj.Flags_ServiSignBase64Flag = true
			DataObj.Flags = Base64Encode(Flags)
			DataObj.iKeyUsage_ServiSignBase64Flag = true
			DataObj.iKeyUsage = Base64Encode(iKeyUsage)
			DataObj.ServiSignFunctionIndex = 19

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIExportPKCS12 : function(strSubject, Flags, iKeyUsage, strPassword, strFilePath, strFileName){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIExportPKCS12"
			DataObj.strSubject_ServiSignBase64Flag = true
			DataObj.strSubject = Base64Encode(strSubject)
			DataObj.Flags_ServiSignBase64Flag = true
			DataObj.Flags = Base64Encode(Flags)
			DataObj.iKeyUsage_ServiSignBase64Flag = true
			DataObj.iKeyUsage = Base64Encode(iKeyUsage)
			DataObj.strPassword_ServiSignBase64Flag = true
			DataObj.strPassword = Base64Encode(strPassword)
			DataObj.strFilePath_ServiSignBase64Flag = true
			DataObj.strFilePath = Base64Encode(strFilePath)
			DataObj.strFileName_ServiSignBase64Flag = true
			DataObj.strFileName = Base64Encode(strFileName)
			DataObj.ServiSignFunctionIndex = 20

			return parseInt(ServiSignObj.Send(DataObj))
		},
		GetErrorCode : function(){
			var DataObj = new Object()
			DataObj.functionname = "GetErrorCode"
			DataObj.ServiSignFunctionIndex = 21

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPISymmetricEncrypt : function(iAlgor, strPasswd, bData){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPISymmetricEncrypt"
			DataObj.iAlgor_ServiSignBase64Flag = true
			DataObj.iAlgor = Base64Encode(iAlgor)
			DataObj.strPasswd_ServiSignBase64Flag = true
			DataObj.strPasswd = Base64Encode(strPasswd)
			DataObj.bData_ServiSignBase64Flag = true
			DataObj.bData = Base64Encode(bData)
			DataObj.ServiSignFunctionIndex = 22

			return ServiSignObj.Send(DataObj)
		},
		FSCAPISymmetricDecrypt : function(iAlgor, strPasswd, cipher){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPISymmetricDecrypt"
			DataObj.iAlgor_ServiSignBase64Flag = true
			DataObj.iAlgor = Base64Encode(iAlgor)
			DataObj.strPasswd_ServiSignBase64Flag = true
			DataObj.strPasswd = Base64Encode(strPasswd)
			DataObj.cipher_ServiSignBase64Flag = true
			DataObj.cipher = Base64Encode(cipher)
			DataObj.ServiSignFunctionIndex = 23

			return ServiSignObj.Send(DataObj)
		},
		FSXCAPICertGetSerialNumber : function(strCert, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSXCAPICertGetSerialNumber"
			DataObj.strCert_ServiSignBase64Flag = true
			DataObj.strCert = Base64Encode(strCert)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 24

			return ServiSignObj.Send(DataObj)
		},
		CheckKeyUsage : function(iCheck){
			var DataObj = new Object()
			DataObj.functionname = "CheckKeyUsage"
			DataObj.iCheck_ServiSignBase64Flag = true
			DataObj.iCheck = Base64Encode(iCheck)
			DataObj.ServiSignFunctionIndex = 25

			return parseInt(ServiSignObj.Send(DataObj))
		},
		GetVerifyRtnSignerInfo : function(){
			var DataObj = new Object()
			DataObj.functionname = "GetVerifyRtnSignerInfo"
			DataObj.ServiSignFunctionIndex = 26

			return ServiSignObj.Send(DataObj)
		},
		GetVerifyRtnCert : function(){
			var DataObj = new Object()
			DataObj.functionname = "GetVerifyRtnCert"
			DataObj.ServiSignFunctionIndex = 27

			return ServiSignObj.Send(DataObj)
		},
		FSCAPICertGetDigest : function(strCert, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPICertGetDigest"
			DataObj.strCert_ServiSignBase64Flag = true
			DataObj.strCert = Base64Encode(strCert)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 28

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIShowCertificateDlg : function(strMsg, strCert){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIShowCertificateDlg"
			DataObj.strMsg_ServiSignBase64Flag = true
			DataObj.strMsg = Base64Encode(strMsg)
			DataObj.strCert_ServiSignBase64Flag = true
			DataObj.strCert = Base64Encode(strCert)
			DataObj.ServiSignFunctionIndex = 29

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPISetDlgLogo : function(strLog){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPISetDlgLogo"
			DataObj.strLog_ServiSignBase64Flag = true
			DataObj.strLog = Base64Encode(strLog)
			DataObj.ServiSignFunctionIndex = 30

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSXCAPISetLanguage : function(strLanguage){
			var DataObj = new Object()
			DataObj.functionname = "FSXCAPISetLanguage"
			DataObj.strLanguage_ServiSignBase64Flag = true
			DataObj.strLanguage = Base64Encode(strLanguage)
			DataObj.ServiSignFunctionIndex = 31

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPIImportPKCS12Ex : function(strPwd, strFilePath, strFileName, friendly_name, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIImportPKCS12Ex"
			DataObj.strPwd_ServiSignBase64Flag = true
			DataObj.strPwd = Base64Encode(strPwd)
			DataObj.strFilePath_ServiSignBase64Flag = true
			DataObj.strFilePath = Base64Encode(strFilePath)
			DataObj.strFileName_ServiSignBase64Flag = true
			DataObj.strFileName = Base64Encode(strFileName)
			DataObj.friendly_name_ServiSignBase64Flag = true
			DataObj.friendly_name = Base64Encode(friendly_name)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 32

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSXCAPIEncode : function(strData, strPemTitle){
			var DataObj = new Object()
			DataObj.functionname = "FSXCAPIEncode"
			DataObj.strData_ServiSignBase64Flag = true
			DataObj.strData = Base64Encode(strData)
			DataObj.strPemTitle_ServiSignBase64Flag = true
			DataObj.strPemTitle = Base64Encode(strPemTitle)
			DataObj.ServiSignFunctionIndex = 33

			return ServiSignObj.Send(DataObj)
		},
		FSXCAPIDecode : function(strEncoded, strPemTitle){
			var DataObj = new Object()
			DataObj.functionname = "FSXCAPIDecode"
			DataObj.strEncoded_ServiSignBase64Flag = true
			DataObj.strEncoded = Base64Encode(strEncoded)
			DataObj.strPemTitle_ServiSignBase64Flag = true
			DataObj.strPemTitle = Base64Encode(strPemTitle)
			DataObj.ServiSignFunctionIndex = 34

			return ServiSignObj.Send(DataObj)
		},
		FSCAPICertGetSubject : function(strCert, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPICertGetSubject"
			DataObj.strCert_ServiSignBase64Flag = true
			DataObj.strCert = Base64Encode(strCert)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 35

			return ServiSignObj.Send(DataObj)
		},
		FSCAPICertGetIssuer : function(strCert, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPICertGetIssuer"
			DataObj.strCert_ServiSignBase64Flag = true
			DataObj.strCert = Base64Encode(strCert)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 36

			return ServiSignObj.Send(DataObj)
		},
		FSCAPICertGetNotBefore : function(strCert, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPICertGetNotBefore"
			DataObj.strCert_ServiSignBase64Flag = true
			DataObj.strCert = Base64Encode(strCert)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 37

			return ServiSignObj.Send(DataObj)
		},
		FSCAPICertGetNotAfter : function(strCert, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPICertGetNotAfter"
			DataObj.strCert_ServiSignBase64Flag = true
			DataObj.strCert = Base64Encode(strCert)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 38

			return ServiSignObj.Send(DataObj)
		},
		FSXCAPISetParentWindowHandle : function(hParent){
			var DataObj = new Object()
			DataObj.functionname = "FSXCAPISetParentWindowHandle"
			DataObj.hParent_ServiSignBase64Flag = true
			DataObj.hParent = Base64Encode(hParent)
			DataObj.ServiSignFunctionIndex = 39

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPICertEncrypt : function(strCert, bData, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPICertEncrypt"
			DataObj.strCert_ServiSignBase64Flag = true
			DataObj.strCert = Base64Encode(strCert)
			DataObj.bData_ServiSignBase64Flag = true
			DataObj.bData = Base64Encode(bData)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 40

			return ServiSignObj.Send(DataObj)
		},
		FSCAPISetDisplayMessage : function(strMessage){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPISetDisplayMessage"
			DataObj.strMessage_ServiSignBase64Flag = true
			DataObj.strMessage = Base64Encode(strMessage)
			DataObj.ServiSignFunctionIndex = 41

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPIGetRtnSignature : function(){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIGetRtnSignature"
			DataObj.ServiSignFunctionIndex = 42

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIGetRtnCert : function(){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIGetRtnCert"
			DataObj.ServiSignFunctionIndex = 43

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIRegisterCertificate : function(strProvider){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIRegisterCertificate"
			DataObj.strProvider_ServiSignBase64Flag = true
			DataObj.strProvider = Base64Encode(strProvider)
			DataObj.ServiSignFunctionIndex = 44

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSXCAPIPKCS7GetUserCertificate : function(p7cert){
			var DataObj = new Object()
			DataObj.functionname = "FSXCAPIPKCS7GetUserCertificate"
			DataObj.p7cert_ServiSignBase64Flag = true
			DataObj.p7cert = Base64Encode(p7cert)
			DataObj.ServiSignFunctionIndex = 45

			return ServiSignObj.Send(DataObj)
		},
		FSXCAPIGetCertSubject : function(subject, field, flag, keyUsage){
			var DataObj = new Object()
			DataObj.functionname = "FSXCAPIGetCertSubject"
			DataObj.subject_ServiSignBase64Flag = true
			DataObj.subject = Base64Encode(subject)
			DataObj.field_ServiSignBase64Flag = true
			DataObj.field = Base64Encode(field)
			DataObj.flag_ServiSignBase64Flag = true
			DataObj.flag = Base64Encode(flag)
			DataObj.keyUsage_ServiSignBase64Flag = true
			DataObj.keyUsage = Base64Encode(keyUsage)
			DataObj.ServiSignFunctionIndex = 46

			return FixArray(ServiSignObj.Send(DataObj))
		},
		FSCAPIShowDebugMessage : function(bShow){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIShowDebugMessage"
			DataObj.bShow_ServiSignBase64Flag = true
			DataObj.bShow = Base64Encode(bShow)
			DataObj.ServiSignFunctionIndex = 47

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSXCAPIGetCertsEx : function(provider, subject, flag, keyUsage, disableATKeySpec){
			var DataObj = new Object()
			DataObj.functionname = "FSXCAPIGetCertsEx"
			DataObj.provider_ServiSignBase64Flag = true
			DataObj.provider = Base64Encode(provider)
			DataObj.subject_ServiSignBase64Flag = true
			DataObj.subject = Base64Encode(subject)
			DataObj.flag_ServiSignBase64Flag = true
			DataObj.flag = Base64Encode(flag)
			DataObj.keyUsage_ServiSignBase64Flag = true
			DataObj.keyUsage = Base64Encode(keyUsage)
			DataObj.disableATKeySpec_ServiSignBase64Flag = true
			DataObj.disableATKeySpec = Base64Encode(disableATKeySpec)
			DataObj.ServiSignFunctionIndex = 48

			return FixArray(ServiSignObj.Send(DataObj))
		},
		FSCAPIRegisterCertificateEx : function(bProvider, iDisableFlag){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIRegisterCertificateEx"
			DataObj.bProvider_ServiSignBase64Flag = true
			DataObj.bProvider = Base64Encode(bProvider)
			DataObj.iDisableFlag_ServiSignBase64Flag = true
			DataObj.iDisableFlag = Base64Encode(iDisableFlag)
			DataObj.ServiSignFunctionIndex = 49

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSXCAPISelectCert : function(subject, Flags, iKeyUsage){
			var DataObj = new Object()
			DataObj.functionname = "FSXCAPISelectCert"
			DataObj.subject_ServiSignBase64Flag = true
			DataObj.subject = Base64Encode(subject)
			DataObj.Flags_ServiSignBase64Flag = true
			DataObj.Flags = Base64Encode(Flags)
			DataObj.iKeyUsage_ServiSignBase64Flag = true
			DataObj.iKeyUsage = Base64Encode(iKeyUsage)
			DataObj.ServiSignFunctionIndex = 50

			return ServiSignObj.Send(DataObj)
		},
		GetSignRtnContent : function(){
			var DataObj = new Object()
			DataObj.functionname = "GetSignRtnContent"
			DataObj.ServiSignFunctionIndex = 51

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIFileEncryptByCert : function(strCert, strFilePath, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIFileEncryptByCert"
			DataObj.strCert_ServiSignBase64Flag = true
			DataObj.strCert = Base64Encode(strCert)
			DataObj.strFilePath_ServiSignBase64Flag = true
			DataObj.strFilePath = Base64Encode(strFilePath)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 52

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIDecrypt2File : function(strCipher, strOutFilePath, Flags, iKeyUsage){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIDecrypt2File"
			DataObj.strCipher_ServiSignBase64Flag = true
			DataObj.strCipher = Base64Encode(strCipher)
			DataObj.strOutFilePath_ServiSignBase64Flag = true
			DataObj.strOutFilePath = Base64Encode(strOutFilePath)
			DataObj.Flags_ServiSignBase64Flag = true
			DataObj.Flags = Base64Encode(Flags)
			DataObj.iKeyUsage_ServiSignBase64Flag = true
			DataObj.iKeyUsage = Base64Encode(iKeyUsage)
			DataObj.ServiSignFunctionIndex = 53

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPIPFXImportSC : function(sBases64PFXFile, strPasswd, strCSP, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIPFXImportSC"
			DataObj.sBases64PFXFile_ServiSignBase64Flag = true
			DataObj.sBases64PFXFile = Base64Encode(sBases64PFXFile)
			DataObj.strPasswd_ServiSignBase64Flag = true
			DataObj.strPasswd = Base64Encode(strPasswd)
			DataObj.strCSP_ServiSignBase64Flag = true
			DataObj.strCSP = Base64Encode(strCSP)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 54

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPI_UsrCertGetProvName : function(subject, Flags, iKeyUsage){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPI_UsrCertGetProvName"
			DataObj.subject_ServiSignBase64Flag = true
			DataObj.subject = Base64Encode(subject)
			DataObj.Flags_ServiSignBase64Flag = true
			DataObj.Flags = Base64Encode(Flags)
			DataObj.iKeyUsage_ServiSignBase64Flag = true
			DataObj.iKeyUsage = Base64Encode(iKeyUsage)
			DataObj.ServiSignFunctionIndex = 55

			return ServiSignObj.Send(DataObj)
		},
		FSCAPI_DeleteUsrCert : function(subject, flag, keyUsage){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPI_DeleteUsrCert"
			DataObj.subject_ServiSignBase64Flag = true
			DataObj.subject = Base64Encode(subject)
			DataObj.flag_ServiSignBase64Flag = true
			DataObj.flag = Base64Encode(flag)
			DataObj.keyUsage_ServiSignBase64Flag = true
			DataObj.keyUsage = Base64Encode(keyUsage)
			DataObj.ServiSignFunctionIndex = 56

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPIAuth : function(strData, strSubject, strProvider, strPin, iFlags, iKeyUsage){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIAuth"
			DataObj.strData_ServiSignBase64Flag = true
			DataObj.strData = Base64Encode(strData)
			DataObj.strSubject_ServiSignBase64Flag = true
			DataObj.strSubject = Base64Encode(strSubject)
			DataObj.strProvider_ServiSignBase64Flag = true
			DataObj.strProvider = Base64Encode(strProvider)
			DataObj.strPin_ServiSignBase64Flag = true
			DataObj.strPin = Base64Encode(strPin)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.iKeyUsage_ServiSignBase64Flag = true
			DataObj.iKeyUsage = Base64Encode(iKeyUsage)
			DataObj.ServiSignFunctionIndex = 57

			return ServiSignObj.Send(DataObj)
		},
		FSCAPI_XGetUserCertificate : function(strProvider, subject, Flags, iKeyUsage){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPI_XGetUserCertificate"
			DataObj.strProvider_ServiSignBase64Flag = true
			DataObj.strProvider = Base64Encode(strProvider)
			DataObj.subject_ServiSignBase64Flag = true
			DataObj.subject = Base64Encode(subject)
			DataObj.Flags_ServiSignBase64Flag = true
			DataObj.Flags = Base64Encode(Flags)
			DataObj.iKeyUsage_ServiSignBase64Flag = true
			DataObj.iKeyUsage = Base64Encode(iKeyUsage)
			DataObj.ServiSignFunctionIndex = 58

			return ServiSignObj.Send(DataObj)
		},
		FSCAPI_AcceptPKCS7 : function(strCertificate, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPI_AcceptPKCS7"
			DataObj.strCertificate_ServiSignBase64Flag = true
			DataObj.strCertificate = Base64Encode(strCertificate)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 59

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPICertGetPublicKey : function(strCert, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPICertGetPublicKey"
			DataObj.strCert_ServiSignBase64Flag = true
			DataObj.strCert = Base64Encode(strCert)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 60

			return ServiSignObj.Send(DataObj)
		},
		FSCAPI_ChangeP12Pwd : function(strPFXFilepath, strOldPwd, strNewPwd, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPI_ChangeP12Pwd"
			DataObj.strPFXFilepath_ServiSignBase64Flag = true
			DataObj.strPFXFilepath = Base64Encode(strPFXFilepath)
			DataObj.strOldPwd_ServiSignBase64Flag = true
			DataObj.strOldPwd = Base64Encode(strOldPwd)
			DataObj.strNewPwd_ServiSignBase64Flag = true
			DataObj.strNewPwd = Base64Encode(strNewPwd)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 61

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPI_GetPFXCertCount : function(sPFXfilepath, strPasswd){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPI_GetPFXCertCount"
			DataObj.sPFXfilepath_ServiSignBase64Flag = true
			DataObj.sPFXfilepath = Base64Encode(sPFXfilepath)
			DataObj.strPasswd_ServiSignBase64Flag = true
			DataObj.strPasswd = Base64Encode(strPasswd)
			DataObj.ServiSignFunctionIndex = 62

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPI_GetFilePath : function(title, fileDesc, fileType, initPath, initFile){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPI_GetFilePath"
			DataObj.title_ServiSignBase64Flag = true
			DataObj.title = Base64Encode(title)
			DataObj.fileDesc_ServiSignBase64Flag = true
			DataObj.fileDesc = Base64Encode(fileDesc)
			DataObj.fileType_ServiSignBase64Flag = true
			DataObj.fileType = Base64Encode(fileType)
			DataObj.initPath_ServiSignBase64Flag = true
			DataObj.initPath = Base64Encode(initPath)
			DataObj.initFile_ServiSignBase64Flag = true
			DataObj.initFile = Base64Encode(initFile)
			DataObj.ServiSignFunctionIndex = 63

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIVerifyEx2 : function(strSignature, bData, signcodepage, strSubject, Flags, iKeyUsage, nTime){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIVerifyEx2"
			DataObj.strSignature_ServiSignBase64Flag = true
			DataObj.strSignature = Base64Encode(strSignature)
			DataObj.bData_ServiSignBase64Flag = true
			DataObj.bData = Base64Encode(bData)
			DataObj.signcodepage_ServiSignBase64Flag = true
			DataObj.signcodepage = Base64Encode(signcodepage)
			DataObj.strSubject_ServiSignBase64Flag = true
			DataObj.strSubject = Base64Encode(strSubject)
			DataObj.Flags_ServiSignBase64Flag = true
			DataObj.Flags = Base64Encode(Flags)
			DataObj.iKeyUsage_ServiSignBase64Flag = true
			DataObj.iKeyUsage = Base64Encode(iKeyUsage)
			DataObj.nTime_ServiSignBase64Flag = true
			DataObj.nTime = Base64Encode(nTime)
			DataObj.ServiSignFunctionIndex = 64

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPI_PKCS7GetSignerCert : function(pkcs7signature, index, Flags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPI_PKCS7GetSignerCert"
			DataObj.pkcs7signature_ServiSignBase64Flag = true
			DataObj.pkcs7signature = Base64Encode(pkcs7signature)
			DataObj.index_ServiSignBase64Flag = true
			DataObj.index = Base64Encode(index)
			DataObj.Flags_ServiSignBase64Flag = true
			DataObj.Flags = Base64Encode(Flags)
			DataObj.ServiSignFunctionIndex = 65

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIGetVerifiedContent : function(pkcs7signature, reserved, Flags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIGetVerifiedContent"
			DataObj.pkcs7signature_ServiSignBase64Flag = true
			DataObj.pkcs7signature = Base64Encode(pkcs7signature)
			DataObj.reserved_ServiSignBase64Flag = true
			DataObj.reserved = Base64Encode(reserved)
			DataObj.Flags_ServiSignBase64Flag = true
			DataObj.Flags = Base64Encode(Flags)
			DataObj.ServiSignFunctionIndex = 66

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIVerifiedContent2File : function(pkcs7signature, reserved, Flags, outfile){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIVerifiedContent2File"
			DataObj.pkcs7signature_ServiSignBase64Flag = true
			DataObj.pkcs7signature = Base64Encode(pkcs7signature)
			DataObj.reserved_ServiSignBase64Flag = true
			DataObj.reserved = Base64Encode(reserved)
			DataObj.Flags_ServiSignBase64Flag = true
			DataObj.Flags = Base64Encode(Flags)
			DataObj.outfile_ServiSignBase64Flag = true
			DataObj.outfile = Base64Encode(outfile)
			DataObj.ServiSignFunctionIndex = 67

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPIComposePKCS7 : function(strCert, B64RawSignature, bData, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIComposePKCS7"
			DataObj.strCert_ServiSignBase64Flag = true
			DataObj.strCert = Base64Encode(strCert)
			DataObj.B64RawSignature_ServiSignBase64Flag = true
			DataObj.B64RawSignature = Base64Encode(B64RawSignature)
			DataObj.bData_ServiSignBase64Flag = true
			DataObj.bData = Base64Encode(bData)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 68

			return ServiSignObj.Send(DataObj)
		},
		FSGetTempPath : function(){
			var DataObj = new Object()
			DataObj.functionname = "FSGetTempPath"
			DataObj.ServiSignFunctionIndex = 69

			return ServiSignObj.Send(DataObj)
		},
		GetHashAlgorithm : function(){
			var DataObj = new Object()
			DataObj.functionname = "GetHashAlgorithm"
			DataObj.ServiSignFunctionIndex = 70

			return ServiSignObj.Send(DataObj)
		},
		PutHashAlgorithm : function(pVal){
			var DataObj = new Object()
			DataObj.functionname = "PutHashAlgorithm"
			DataObj.pVal_ServiSignBase64Flag = true
			DataObj.pVal = Base64Encode(pVal)
			DataObj.ServiSignFunctionIndex = 71

			return parseInt(ServiSignObj.Send(DataObj))
		},
		GetproviderType : function(){
			var DataObj = new Object()
			DataObj.functionname = "GetproviderType"
			DataObj.ServiSignFunctionIndex = 72

			return parseInt(ServiSignObj.Send(DataObj))
		},
		PutproviderType : function(pVal){
			var DataObj = new Object()
			DataObj.functionname = "PutproviderType"
			DataObj.pVal_ServiSignBase64Flag = true
			DataObj.pVal = Base64Encode(pVal)
			DataObj.ServiSignFunctionIndex = 73

			return parseInt(ServiSignObj.Send(DataObj))
		},
		GetproviderName : function(){
			var DataObj = new Object()
			DataObj.functionname = "GetproviderName"
			DataObj.ServiSignFunctionIndex = 74

			return ServiSignObj.Send(DataObj)
		},
		PutproviderName : function(pVal){
			var DataObj = new Object()
			DataObj.functionname = "PutproviderName"
			DataObj.pVal_ServiSignBase64Flag = true
			DataObj.pVal = Base64Encode(pVal)
			DataObj.ServiSignFunctionIndex = 75

			return parseInt(ServiSignObj.Send(DataObj))
		},
		GetKeySpec : function(){
			var DataObj = new Object()
			DataObj.functionname = "GetKeySpec"
			DataObj.ServiSignFunctionIndex = 76

			return parseInt(ServiSignObj.Send(DataObj))
		},
		PutKeySpec : function(pVal){
			var DataObj = new Object()
			DataObj.functionname = "PutKeySpec"
			DataObj.pVal_ServiSignBase64Flag = true
			DataObj.pVal = Base64Encode(pVal)
			DataObj.ServiSignFunctionIndex = 77

			return parseInt(ServiSignObj.Send(DataObj))
		},
		GetGenKeyFlags : function(){
			var DataObj = new Object()
			DataObj.functionname = "GetGenKeyFlags"
			DataObj.ServiSignFunctionIndex = 78

			return parseInt(ServiSignObj.Send(DataObj))
		},
		PutGenKeyFlags : function(pVal){
			var DataObj = new Object()
			DataObj.functionname = "PutGenKeyFlags"
			DataObj.pVal_ServiSignBase64Flag = true
			DataObj.pVal = Base64Encode(pVal)
			DataObj.ServiSignFunctionIndex = 79

			return parseInt(ServiSignObj.Send(DataObj))
		},
		GetDeleteRequestCert : function(){
			var DataObj = new Object()
			DataObj.functionname = "GetDeleteRequestCert"
			DataObj.ServiSignFunctionIndex = 80

			return parseInt(ServiSignObj.Send(DataObj))
		},
		PutDeleteRequestCert : function(pVal){
			var DataObj = new Object()
			DataObj.functionname = "PutDeleteRequestCert"
			DataObj.pVal_ServiSignBase64Flag = true
			DataObj.pVal = Base64Encode(pVal)
			DataObj.ServiSignFunctionIndex = 81

			return parseInt(ServiSignObj.Send(DataObj))
		},
		GetWriteCertToCSP : function(){
			var DataObj = new Object()
			DataObj.functionname = "GetWriteCertToCSP"
			DataObj.ServiSignFunctionIndex = 82

			return parseInt(ServiSignObj.Send(DataObj))
		},
		PutWriteCertToCSP : function(pVal){
			var DataObj = new Object()
			DataObj.functionname = "PutWriteCertToCSP"
			DataObj.pVal_ServiSignBase64Flag = true
			DataObj.pVal = Base64Encode(pVal)
			DataObj.ServiSignFunctionIndex = 83

			return parseInt(ServiSignObj.Send(DataObj))
		},
		enumProviders : function(dwIndex, dwFlags){
			var DataObj = new Object()
			DataObj.functionname = "enumProviders"
			DataObj.dwIndex_ServiSignBase64Flag = true
			DataObj.dwIndex = Base64Encode(dwIndex)
			DataObj.dwFlags_ServiSignBase64Flag = true
			DataObj.dwFlags = Base64Encode(dwFlags)
			DataObj.ServiSignFunctionIndex = 84

			var result = ServiSignObj.KeepAlive(DataObj)
			if(isServiSignErrorCode(result)) throw "ServiSign Exception"
			return result
		},
		acceptPKCS7 : function(strCert){
			var DataObj = new Object()
			DataObj.functionname = "acceptPKCS7"
			DataObj.strCert_ServiSignBase64Flag = true
			DataObj.strCert = Base64Encode(strCert)
			DataObj.ServiSignFunctionIndex = 85

			return parseInt(ServiSignObj.Send(DataObj))
		},
		createPKCS10 : function(dn, bOID){
			var DataObj = new Object()
			DataObj.functionname = "createPKCS10"
			DataObj.dn_ServiSignBase64Flag = true
			DataObj.dn = Base64Encode(dn)
			DataObj.bOID_ServiSignBase64Flag = true
			DataObj.bOID = Base64Encode(bOID)
			DataObj.ServiSignFunctionIndex = 86

			return ServiSignObj.Send(DataObj)
		},
		FSCAPI_CheckPFX : function(sB64PFX, strPasswd, strSubject, iFlags, iKeyUsage){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPI_CheckPFX"
			DataObj.sB64PFX_ServiSignBase64Flag = true
			DataObj.sB64PFX = Base64Encode(sB64PFX)
			DataObj.strPasswd_ServiSignBase64Flag = true
			DataObj.strPasswd = Base64Encode(strPasswd)
			DataObj.strSubject_ServiSignBase64Flag = true
			DataObj.strSubject = Base64Encode(strSubject)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.iKeyUsage_ServiSignBase64Flag = true
			DataObj.iKeyUsage = Base64Encode(iKeyUsage)
			DataObj.ServiSignFunctionIndex = 87

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPI_DeleteUsrCertEx : function(strProvider, strSubject, iFlags, iKeyUsage){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPI_DeleteUsrCertEx"
			DataObj.strProvider_ServiSignBase64Flag = true
			DataObj.strProvider = Base64Encode(strProvider)
			DataObj.strSubject_ServiSignBase64Flag = true
			DataObj.strSubject = Base64Encode(strSubject)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.iKeyUsage_ServiSignBase64Flag = true
			DataObj.iKeyUsage = Base64Encode(iKeyUsage)
			DataObj.ServiSignFunctionIndex = 88

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPI_CheckPermission : function(){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPI_CheckPermission"
			DataObj.ServiSignFunctionIndex = 89

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPIPureVerify : function(strSignature, strData, strSubject, iFlags, iHashalg, iKeyUsage){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIPureVerify"
			DataObj.strSignature_ServiSignBase64Flag = true
			DataObj.strSignature = Base64Encode(strSignature)
			DataObj.strData_ServiSignBase64Flag = true
			DataObj.strData = Base64Encode(strData)
			DataObj.strSubject_ServiSignBase64Flag = true
			DataObj.strSubject = Base64Encode(strSubject)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.iHashalg_ServiSignBase64Flag = true
			DataObj.iHashalg = Base64Encode(iHashalg)
			DataObj.iKeyUsage_ServiSignBase64Flag = true
			DataObj.iKeyUsage = Base64Encode(iKeyUsage)
			DataObj.ServiSignFunctionIndex = 90

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPISetDisplayMessageFont : function(font, size){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPISetDisplayMessageFont"
			DataObj.font_ServiSignBase64Flag = true
			DataObj.font = Base64Encode(font)
			DataObj.size_ServiSignBase64Flag = true
			DataObj.size = Base64Encode(size)
			DataObj.ServiSignFunctionIndex = 91

			return parseInt(ServiSignObj.Send(DataObj))
		},
		GetDecrypRtnCert : function(){
			var DataObj = new Object()
			DataObj.functionname = "GetDecrypRtnCert"
			DataObj.ServiSignFunctionIndex = 92

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIUnRegisterCertificateEx : function(bProvider, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIUnRegisterCertificateEx"
			DataObj.bProvider_ServiSignBase64Flag = true
			DataObj.bProvider = Base64Encode(bProvider)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 93

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPISymmetricRawKeyEncrypt : function(iAlgor, bRawKey, bRawIV, bData){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPISymmetricRawKeyEncrypt"
			DataObj.iAlgor_ServiSignBase64Flag = true
			DataObj.iAlgor = Base64Encode(iAlgor)
			DataObj.bRawKey_ServiSignBase64Flag = true
			DataObj.bRawKey = Base64Encode(bRawKey)
			DataObj.bRawIV_ServiSignBase64Flag = true
			DataObj.bRawIV = Base64Encode(bRawIV)
			DataObj.bData_ServiSignBase64Flag = true
			DataObj.bData = Base64Encode(bData)
			DataObj.ServiSignFunctionIndex = 94

			return ServiSignObj.Send(DataObj)
		},
		FSCAPISymmetricRawKeyDecrypt : function(iAlgor, bRawKey, bRawIV, bCipher){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPISymmetricRawKeyDecrypt"
			DataObj.iAlgor_ServiSignBase64Flag = true
			DataObj.iAlgor = Base64Encode(iAlgor)
			DataObj.bRawKey_ServiSignBase64Flag = true
			DataObj.bRawKey = Base64Encode(bRawKey)
			DataObj.bRawIV_ServiSignBase64Flag = true
			DataObj.bRawIV = Base64Encode(bRawIV)
			DataObj.bCipher_ServiSignBase64Flag = true
			DataObj.bCipher = Base64Encode(bCipher)
			DataObj.ServiSignFunctionIndex = 95

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIPKCS7GetEncryptedDigest : function(pkcs7signature, Flags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIPKCS7GetEncryptedDigest"
			DataObj.pkcs7signature_ServiSignBase64Flag = true
			DataObj.pkcs7signature = Base64Encode(pkcs7signature)
			DataObj.Flags_ServiSignBase64Flag = true
			DataObj.Flags = Base64Encode(Flags)
			DataObj.ServiSignFunctionIndex = 96

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIImportPKCS12 : function(strPwd, strFilePath, strFileName, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIImportPKCS12"
			DataObj.strPwd_ServiSignBase64Flag = true
			DataObj.strPwd = Base64Encode(strPwd)
			DataObj.strFilePath_ServiSignBase64Flag = true
			DataObj.strFilePath = Base64Encode(strFilePath)
			DataObj.strFileName_ServiSignBase64Flag = true
			DataObj.strFileName = Base64Encode(strFileName)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 97

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPICertConfig : function(bUserID, bConsoleCode, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPICertConfig"
			DataObj.bUserID_ServiSignBase64Flag = true
			DataObj.bUserID = Base64Encode(bUserID)
			DataObj.bConsoleCode_ServiSignBase64Flag = true
			DataObj.bConsoleCode = Base64Encode(bConsoleCode)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 98

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPITSCP12XGetUserCertificate : function(strPwd, strFilePath, strFileName){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPITSCP12XGetUserCertificate"
			DataObj.strPwd_ServiSignBase64Flag = true
			DataObj.strPwd = Base64Encode(strPwd)
			DataObj.strFilePath_ServiSignBase64Flag = true
			DataObj.strFilePath = Base64Encode(strFilePath)
			DataObj.strFileName_ServiSignBase64Flag = true
			DataObj.strFileName = Base64Encode(strFileName)
			DataObj.ServiSignFunctionIndex = 99

			return ServiSignObj.Send(DataObj)
		},
		FS_GETVersion : function(flag){
			var DataObj = new Object()
			DataObj.functionname = "FS_GETVersion"
			DataObj.flag_ServiSignBase64Flag = true
			DataObj.flag = Base64Encode(flag)
			DataObj.ServiSignFunctionIndex = 100

			return ServiSignObj.Send(DataObj)
		},
		acceptPKCS7Ex : function(bCert, bPIN){
			var DataObj = new Object()
			DataObj.functionname = "acceptPKCS7Ex"
			DataObj.bCert_ServiSignBase64Flag = true
			DataObj.bCert = Base64Encode(bCert)
			DataObj.bPIN_ServiSignBase64Flag = true
			DataObj.bPIN = Base64Encode(bPIN)
			DataObj.ServiSignFunctionIndex = 101

			return parseInt(ServiSignObj.Send(DataObj))
		},
		GetfriendlyName : function(){
			var DataObj = new Object()
			DataObj.functionname = "GetfriendlyName"
			DataObj.ServiSignFunctionIndex = 102

			return ServiSignObj.Send(DataObj)
		},
		PutfriendlyName : function(pVal){
			var DataObj = new Object()
			DataObj.functionname = "PutfriendlyName"
			DataObj.pVal_ServiSignBase64Flag = true
			DataObj.pVal = Base64Encode(pVal)
			DataObj.ServiSignFunctionIndex = 103

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPIP12XGetUserCertificate : function(strPwd, strFilePath, strFileName){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIP12XGetUserCertificate"
			DataObj.strPwd_ServiSignBase64Flag = true
			DataObj.strPwd = Base64Encode(strPwd)
			DataObj.strFilePath_ServiSignBase64Flag = true
			DataObj.strFilePath = Base64Encode(strFilePath)
			DataObj.strFileName_ServiSignBase64Flag = true
			DataObj.strFileName = Base64Encode(strFileName)
			DataObj.ServiSignFunctionIndex = 104

			return ServiSignObj.Send(DataObj)
		},
		FSCAPI_InstallCert : function(strCertificate, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPI_InstallCert"
			DataObj.strCertificate_ServiSignBase64Flag = true
			DataObj.strCertificate = Base64Encode(strCertificate)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 105

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSGetMyDocumentsPath : function(){
			var DataObj = new Object()
			DataObj.functionname = "FSGetMyDocumentsPath"
			DataObj.ServiSignFunctionIndex = 106

			return ServiSignObj.Send(DataObj)
		},
		FSCAPISymmetricEncryptFile : function(iAlgor, strPasswd, bSrcPath, bDstPath){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPISymmetricEncryptFile"
			DataObj.iAlgor_ServiSignBase64Flag = true
			DataObj.iAlgor = Base64Encode(iAlgor)
			DataObj.strPasswd_ServiSignBase64Flag = true
			DataObj.strPasswd = Base64Encode(strPasswd)
			DataObj.bSrcPath_ServiSignBase64Flag = true
			DataObj.bSrcPath = Base64Encode(bSrcPath)
			DataObj.bDstPath_ServiSignBase64Flag = true
			DataObj.bDstPath = Base64Encode(bDstPath)
			DataObj.ServiSignFunctionIndex = 107

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPISymmetricDecryptFile : function(iAlgor, strPasswd, bSrcPath, bDstPath){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPISymmetricDecryptFile"
			DataObj.iAlgor_ServiSignBase64Flag = true
			DataObj.iAlgor = Base64Encode(iAlgor)
			DataObj.strPasswd_ServiSignBase64Flag = true
			DataObj.strPasswd = Base64Encode(strPasswd)
			DataObj.bSrcPath_ServiSignBase64Flag = true
			DataObj.bSrcPath = Base64Encode(bSrcPath)
			DataObj.bDstPath_ServiSignBase64Flag = true
			DataObj.bDstPath = Base64Encode(bDstPath)
			DataObj.ServiSignFunctionIndex = 108

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPI_UsrCertGetContainerName : function(subject, Flags, iKeyUsage){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPI_UsrCertGetContainerName"
			DataObj.subject_ServiSignBase64Flag = true
			DataObj.subject = Base64Encode(subject)
			DataObj.Flags_ServiSignBase64Flag = true
			DataObj.Flags = Base64Encode(Flags)
			DataObj.iKeyUsage_ServiSignBase64Flag = true
			DataObj.iKeyUsage = Base64Encode(iKeyUsage)
			DataObj.ServiSignFunctionIndex = 109

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIPFXImportSCEx : function(sPFXfilepath, strPasswd, strCSP, strPin, iFlags){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIPFXImportSCEx"
			DataObj.sPFXfilepath_ServiSignBase64Flag = true
			DataObj.sPFXfilepath = Base64Encode(sPFXfilepath)
			DataObj.strPasswd_ServiSignBase64Flag = true
			DataObj.strPasswd = Base64Encode(strPasswd)
			DataObj.strCSP_ServiSignBase64Flag = true
			DataObj.strCSP = Base64Encode(strCSP)
			DataObj.strPin_ServiSignBase64Flag = true
			DataObj.strPin = Base64Encode(strPin)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.ServiSignFunctionIndex = 110

			return parseInt(ServiSignObj.Send(DataObj))
		},
		createPKCS10Ex : function(dn, oid, bPIN){
			var DataObj = new Object()
			DataObj.functionname = "createPKCS10Ex"
			DataObj.dn_ServiSignBase64Flag = true
			DataObj.dn = Base64Encode(dn)
			DataObj.oid_ServiSignBase64Flag = true
			DataObj.oid = Base64Encode(oid)
			DataObj.bPIN_ServiSignBase64Flag = true
			DataObj.bPIN = Base64Encode(bPIN)
			DataObj.ServiSignFunctionIndex = 111

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIKGISign : function(UserID, plaindata, Sign_Type, CA_Type){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIKGISign"
			DataObj.UserID_ServiSignBase64Flag = true
			DataObj.UserID = Base64Encode(UserID)
			DataObj.plaindata_ServiSignBase64Flag = true
			DataObj.plaindata = Base64Encode(plaindata)
			DataObj.Sign_Type_ServiSignBase64Flag = true
			DataObj.Sign_Type = Base64Encode(Sign_Type)
			DataObj.CA_Type_ServiSignBase64Flag = true
			DataObj.CA_Type = Base64Encode(CA_Type)
			DataObj.ServiSignFunctionIndex = 112

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIKGIGetNoAfter : function(){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIKGIGetNoAfter"
			DataObj.ServiSignFunctionIndex = 113

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIKGIGetSN : function(){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIKGIGetSN"
			DataObj.ServiSignFunctionIndex = 114

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIKGIGetCert : function(){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIKGIGetCert"
			DataObj.ServiSignFunctionIndex = 115

			return ServiSignObj.Send(DataObj)
		},
		FSCAPIKGI_PFXSign : function(sPFXfilepath, strPasswd, data, iFlags, iKeyUsage){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIKGI_PFXSign"
			DataObj.sPFXfilepath_ServiSignBase64Flag = true
			DataObj.sPFXfilepath = Base64Encode(sPFXfilepath)
			DataObj.strPasswd_ServiSignBase64Flag = true
			DataObj.strPasswd = Base64Encode(strPasswd)
			DataObj.data_ServiSignBase64Flag = true
			DataObj.data = Base64Encode(data)
			DataObj.iFlags_ServiSignBase64Flag = true
			DataObj.iFlags = Base64Encode(iFlags)
			DataObj.iKeyUsage_ServiSignBase64Flag = true
			DataObj.iKeyUsage = Base64Encode(iKeyUsage)
			DataObj.ServiSignFunctionIndex = 116

			return ServiSignObj.Send(DataObj)
		},
		UserBrowser : function(bBrowser){
			var DataObj = new Object()
			DataObj.functionname = "UserBrowser"
			DataObj.bBrowser_ServiSignBase64Flag = true
			DataObj.bBrowser = Base64Encode(bBrowser)
			DataObj.ServiSignFunctionIndex = 117

			return parseInt(ServiSignObj.Send(DataObj))
		},
		FSCAPIKGISign_eDDA : function(UserID, plaindata, Sign_Type, CA_Type, iHashFlags, iInputEncodingFlag){
			var DataObj = new Object()
			DataObj.functionname = "FSCAPIKGISign_eDDA"
			DataObj.UserID_ServiSignBase64Flag = true
			DataObj.UserID = Base64Encode(UserID)
			DataObj.plaindata_ServiSignBase64Flag = true
			DataObj.plaindata = Base64Encode(plaindata)
			DataObj.Sign_Type_ServiSignBase64Flag = true
			DataObj.Sign_Type = Base64Encode(Sign_Type)
			DataObj.CA_Type_ServiSignBase64Flag = true
			DataObj.CA_Type = Base64Encode(CA_Type)
			DataObj.iHashFlags_ServiSignBase64Flag = true
			DataObj.iHashFlags = Base64Encode(iHashFlags)
			DataObj.iInputEncodingFlag_ServiSignBase64Flag = true
			DataObj.iInputEncodingFlag = Base64Encode(iInputEncodingFlag)
			DataObj.ServiSignFunctionIndex = 118

			return ServiSignObj.Send(DataObj)
		}
	}
	Object.defineProperties(ServiSignInterface, {
		"KeySpec": {
			get: function() {
				return ServiSignInterface.ServiSignProperty_propget_KeySpec()
			},
			set: function(input) {
				ServiSignInterface.ServiSignProperty_propput_KeySpec(input)
			}
		},
		"DeleteRequestCert": {
			get: function() {
				return ServiSignInterface.ServiSignProperty_propget_DeleteRequestCert()
			},
			set: function(input) {
				ServiSignInterface.ServiSignProperty_propput_DeleteRequestCert(input)
			}
		},
		"WriteCertToCSP": {
			get: function() {
				return ServiSignInterface.ServiSignProperty_propget_WriteCertToCSP()
			},
			set: function(input) {
				ServiSignInterface.ServiSignProperty_propput_WriteCertToCSP(input)
			}
		},
		"GenKeyFlags": {
			get: function() {
				return ServiSignInterface.ServiSignProperty_propget_GenKeyFlags()
			},
			set: function(input) {
				ServiSignInterface.ServiSignProperty_propput_GenKeyFlags(input)
			}
		},
		"providerType": {
			get: function() {
				return ServiSignInterface.ServiSignProperty_propget_providerType()
			},
			set: function(input) {
				ServiSignInterface.ServiSignProperty_propput_providerType(input)
			}
		},
		"providerName": {
			get: function() {
				return ServiSignInterface.ServiSignProperty_propget_providerName()
			},
			set: function(input) {
				ServiSignInterface.ServiSignProperty_propput_providerName(input)
			}
		},
		"friendlyName": {
			get: function() {
				return ServiSignInterface.ServiSignProperty_propget_friendlyName()
			},
			set: function(input) {
				ServiSignInterface.ServiSignProperty_propput_friendlyName(input)
			}
		},
		"HashAlgorithm": {
			get: function() {
				return ServiSignInterface.ServiSignProperty_propget_HashAlgorithm()
			},
			set: function(input) {
				ServiSignInterface.ServiSignProperty_propput_HashAlgorithm(input)
			}
		},
	});

	window.addEventListener("beforeunload", function (e) {
		if(ServiSignTabMode == ServiSignTabMode_Tab){
			ServiSignObj.ServiSignRelease()
		}
		else if(ServiSignTabMode == ServiSignTabMode_Browser){
			//Do nothing
		}
	})
	if(!ServiSignObj.ServiSigninit()){
		if (typeof cb != "function") {
			ServiSignLoadComponentError()
			return undefined
		}
	}

	return ServiSignInterface
}

function ServiSign_GetErrorCode(){
	return ServiSignErrorCode
}
