const getFields = (strategyId) => {
	return [
		`SymbolRoot-${strategyId}`,
		`ContractMonth-${strategyId}`,
		`Multiplier-${strategyId}`,
		`AccountId-${strategyId}`,
	];
};

const StrategyControlPane = {
	disableFields: (strategyId) => {
		for (const field of getFields(strategyId)) {
			const element = document.getElementById(field);
			if (element) {
				element.disabled = true;
			}
		}
	},

	enableFields: (strategyId) => {
		for (const field of getFields(strategyId)) {
			const element = document.getElementById(field);
			if (element) {
				element.disabled = false;
			}
		}
	},

	updateContractMonths: (strategyId, symbolRoot) => {
		const contractMonthSelect = document.getElementById(
			`ContractMonth-${strategyId}`,
		);

		if (!symbolRoot) {
			contractMonthSelect.innerHTML = "";
			return;
		}

		InternalApiClient.listContractMonths(symbolRoot, (data) => {
			contractMonthSelect.innerHTML = "";

			for (const month of data) {
				const option = document.createElement("option");
				option.value = month;
				option.textContent = month;
				contractMonthSelect.appendChild(option);
			}
		});
	},

	getPlainTextData: (strategyId) => {
		if (!strategyId) {
			return "Empty";
		}

		const symbolRoot = document.getElementById(
			`SymbolRoot-${strategyId}`,
		).value;

		const contractMonthValue = document.getElementById(
			`ContractMonth-${strategyId}`,
		).value;

		const contractMonth =
			contractMonthValue === "熱門月" ? "000000" : contractMonthValue;

		const orderMultiplier = document.getElementById(
			`Multiplier-${strategyId}`,
		).value;

		const accountId = document.getElementById(`AccountId-${strategyId}`).value;

		return `${strategyId},${symbolRoot},${contractMonth},${orderMultiplier},${accountId},${clientIp}`;
	},

	/** Handle switch button toggle event */
	toggleStatus: (strategyId) => {
		const isActivated = document.getElementById(
			`IsActivated-${strategyId}`,
        ).checked;

		if (!isActivated) {
			InternalApiClient.deleteTradingCondition(
				strategyId,
				document.getElementById(`ConditionId-${strategyId}`).value,
			);
			return;
        }
        

		const symbolRoot = document.getElementById(
			`SymbolRoot-${strategyId}`,
		).value;

		const contractMonth = document.getElementById(
			`ContractMonth-${strategyId}`,
		).value;

		const multiplier = document.getElementById(
			`Multiplier-${strategyId}`,
		).value;

		if (
			!TradingConditionValidator.validate(
				strategyId,
				symbolRoot,
				contractMonth,
				multiplier,
			)
		) {
			return;
		}

		window.currentStrategyId = strategyId;
		TermsOfUse.open();
	},
};
