const CreateTradingConditionRequest = {
	createForMobile: (signature, certSeq, strategyId = undefined) => {
		if (!strategyId) {
			strategyId = window.currentStrategyId;
		}

		return {
			strategyId: strategyId,
			brokerageAccount: document.getElementById(`AccountId-${strategyId}`)
				.value,
			idNumber: userId,
			ipAddress: clientIp,
			symbolRoot: document.getElementById(`SymbolRoot-${strategyId}`).value,
			contractMonth:
				document.getElementById(`ContractMonth-${strategyId}`).value ===
				"熱門月"
					? "000000"
					: document.getElementById(`ContractMonth-${strategyId}`).value,
			orderMultiplier: document.getElementById(`Multiplier-${strategyId}`)
				.value,
            signature: signature,
            cert: null,
            certSeq: certSeq,
            deviceType: deviceName,
		};
	},

	createForWindows: (strategyId) => {
		const symbolRoot = document.getElementById(
			`SymbolRoot-${strategyId}`,
		).value;
		const contractMonthValue = document.getElementById(
			`ContractMonth-${strategyId}`,
		).value;
		const contractMonth =
			contractMonthValue === "熱門月" ? "000000" : contractMonthValue;
		const orderMultiplier = document.getElementById(
			`Multiplier-${strategyId}`,
		).value;
		const accountId = document.getElementById(`AccountId-${strategyId}`).value;

		const signature = SignatureHandler.generateForWindows(
			strategyId,
			symbolRoot,
			contractMonth,
			orderMultiplier,
			accountId,
		);

		if (!signature) {
			alert(
				`簽章失敗. 請檢查憑證是否匯入! 錯誤代碼: ${Number.parseInt(
					ServiSign_GetErrorCode(),
				)}`,
			);
			document.getElementById(`IsActivated-${strategyId}`).checked = false;
			CurrentUser.signOut();
			return;
        }

        const cert = signatureService.FSCAPIKGIGetCert();

        if (!cert) {
            alert('無法取得X.509憑證');
            Logger.logError(`無法取得X.509憑證, UserId=${userId}, IP=${clientIp}, StrategyId=${strategyId}`);
        }

        const certSeq = signatureService.FSCAPIKGIGetSN();
        
        if (!certSeq) {
            alert('無法取得憑證序號');
            Logger.logError(`無法取得憑證序號, UserId=${userId}, IP=${clientIp}, StrategyId=${strategyId}`);
        }

		return {
            signature: signature,
            cert,
            certSeq: certSeq,
			strategyId: strategyId,
			brokerageAccount: accountId,
			idNumber: userId,
			ipAddress: clientIp,
			symbolRoot: symbolRoot,
			contractMonth: contractMonth,
			orderMultiplier: orderMultiplier,
            deviceType: deviceName,
		};
	},

	createForWindowsMulti: (strategyIds) => {
		const requests = [];
		for (const id of strategyIds) {
			const request = CreateTradingConditionRequest.createForWindows(id);

			const validationResult = TradingConditionValidator.validate(
				id,
				request.symbolRoot,
				request.contractMonth,
				request.orderMultiplier,
			);

			if (!validationResult) {
				return;
			}
            Logger.logInfo(`客戶同意凱基期貨策略條件單風險聲明同意畫面, UserId=${userId}, IP=${clientIp}, StrategyId=${id}, Device: ${deviceName}`);
			requests.push(request);
		}

		return requests;
	},
};
